/*
 * Decompiled with CFR 0.152.
 */
package MH;

import MH.ActionCheckbox;
import MH.ActionTextField;
import MH.InstantScrollbar;
import MH.MHFileFilter;
import MH.ResourceLoader;
import MH.TunedPipe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TunedPipeDesigner
extends JApplet
implements WindowListener,
ActionListener,
Printable {
    TunedPipe m_Pipe;
    JButton thePrintButton;
    JButton theExportButton;
    private static Locale m_Locale;
    public static String sLineTerminator;
    public static String sPathSeparator;
    public static String sDXF;
    private static ResourceBundle m_Bundle;
    private String m_sCurrentPath = "";
    static String currentLanguage;
    static String localeFontName;

    static {
        sLineTerminator = "\n";
        sPathSeparator = ";";
        sDXF = ".dxf";
        currentLanguage = "";
        localeFontName = "";
    }

    public TunedPipeDesigner() {
        this.setLocale(Locale.getDefault());
        this.m_Pipe = new TunedPipe();
        TunedPipe.setUnitMM(TunedPipeDesigner.getLocalString("UNIT_LENGTH_MM"));
        TunedPipe.setFontName(TunedPipeDesigner.getLocaleFontName(false));
    }

    @Override
    public void init() {
        Container theContentPane = this.getContentPane();
        try {
            Properties props = System.getProperties();
            sLineTerminator = props.getProperty("line.separator");
            sPathSeparator = props.getProperty("path.separator");
        }
        catch (SecurityException props) {
            // empty catch block
        }
        DecimalFormat theFormat = new DecimalFormat();
        theFormat.setMaximumFractionDigits(0);
        theFormat.setMinimumFractionDigits(0);
        theFormat.setGroupingUsed(false);
        theContentPane.setLayout(new BorderLayout());
        JPanel thePanel = new JPanel(new GridLayout(7, 5));
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalString("RPM")));
        double dValue = 12000.0;
        ActionTextField theText = new ActionTextField(theFormat.format(dValue), 0, this.m_Pipe);
        InstantScrollbar theScroll = new InstantScrollbar((int)dValue, 100, 0, 40000, 0, theText, this.m_Pipe);
        theText.setScrollBar(theScroll);
        this.m_Pipe.setRPM(dValue);
        thePanel.add(theText);
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalUnit("RPM")));
        thePanel.add(theScroll);
        thePanel.add(new JLabel("0 ... 40000 " + TunedPipeDesigner.getLocalString("UNIT_RPM")));
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalString("EX_ANGLE")));
        dValue = 150.0;
        theText = new ActionTextField(theFormat.format(dValue), 2, this.m_Pipe);
        theScroll = new InstantScrollbar((int)dValue, 5, 0, 360, 2, theText, this.m_Pipe);
        theText.setScrollBar(theScroll);
        this.m_Pipe.setExhaustAngle(dValue);
        thePanel.add(theText);
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalUnit("DEGREE")));
        thePanel.add(theScroll);
        thePanel.add(new JLabel("0" + TunedPipeDesigner.getLocalString("UNIT_DEGREE") + " ... 360" + TunedPipeDesigner.getLocalString("UNIT_DEGREE")));
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalString("TR_ANGLE")));
        dValue = 130.0;
        theText = new ActionTextField(theFormat.format(dValue), 1, this.m_Pipe);
        theScroll = new InstantScrollbar((int)dValue, 5, 0, 360, 1, theText, this.m_Pipe);
        theText.setScrollBar(theScroll);
        this.m_Pipe.setTransferAngle(dValue);
        thePanel.add(theText);
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalUnit("DEGREE")));
        thePanel.add(theScroll);
        thePanel.add(new JLabel("0" + TunedPipeDesigner.getLocalString("UNIT_DEGREE") + " ... 360" + TunedPipeDesigner.getLocalString("UNIT_DEGREE")));
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalString("EX_AREA")));
        dValue = 100.0;
        theText = new ActionTextField(theFormat.format(dValue), 3, this.m_Pipe);
        theScroll = new InstantScrollbar((int)dValue, 5, 0, 1000, 3, theText, this.m_Pipe);
        theText.setScrollBar(theScroll);
        this.m_Pipe.setExhaustArea(dValue);
        thePanel.add(theText);
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalUnit("AREA_MM2")));
        thePanel.add(theScroll);
        thePanel.add(new JLabel("0 ... 1000 " + TunedPipeDesigner.getLocalString("UNIT_AREA_MM2")));
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalString("EX_TEMP")));
        dValue = 450.0;
        theText = new ActionTextField(theFormat.format(dValue), 4, this.m_Pipe);
        theScroll = new InstantScrollbar((int)dValue, 5, 400, 1000, 4, theText, this.m_Pipe);
        theText.setScrollBar(theScroll);
        this.m_Pipe.setExhaustTemperature(dValue);
        thePanel.add(theText);
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalUnit("KELVIN")));
        thePanel.add(theScroll);
        thePanel.add(new JLabel("400 ... 1000 " + TunedPipeDesigner.getLocalString("UNIT_KELVIN")));
        thePanel.add(new JLabel(" "));
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalString("ENTER")));
        thePanel.add(new JLabel(" "));
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalString("ADJUST")));
        thePanel.add(new JLabel(" "));
        thePanel.add(new JLabel(TunedPipeDesigner.getLocalString("FUEL")));
        ButtonGroup theGroup = new ButtonGroup();
        ActionCheckbox theRadioButton = new ActionCheckbox(TunedPipeDesigner.getLocalString("METH"), theGroup, true, this.m_Pipe, 0);
        thePanel.add(theRadioButton);
        theRadioButton = new ActionCheckbox(TunedPipeDesigner.getLocalString("GAS"), theGroup, false, this.m_Pipe, 1);
        thePanel.add(theRadioButton);
        this.m_Pipe.setFuelType(0);
        thePanel.add(new JLabel(" "));
        thePanel.add(new JLabel(" "));
        theContentPane.add((Component)thePanel, "Center");
        this.m_Pipe.setSize(500, 260);
        theContentPane.add((Component)this.m_Pipe, "North");
        thePanel = new JPanel();
        this.thePrintButton = new JButton(TunedPipeDesigner.getLocalString("PRINT"));
        this.thePrintButton.addActionListener(this);
        thePanel.add(this.thePrintButton);
        this.theExportButton = new JButton(TunedPipeDesigner.getLocalString("EXPORT"));
        this.theExportButton.addActionListener(this);
        this.theExportButton.setEnabled(TunedPipeDesigner.isFileIOAllowed());
        thePanel.add(this.theExportButton);
        theContentPane.add((Component)thePanel, "South");
    }

    public static void main(String[] args) {
        ResourceLoader theLoader = new ResourceLoader();
        JFrame theAppFrame = new JFrame("JavaPipe");
        theAppFrame.setIconImage(theLoader.getImageResource("javapipe32.jpg"));
        WindowAdapter theListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        theAppFrame.addWindowListener(theListener);
        TunedPipeDesigner theApplet = new TunedPipeDesigner();
        theApplet.init();
        theAppFrame.getContentPane().add("Center", theApplet);
        theAppFrame.addWindowListener(theApplet);
        theAppFrame.setSize(700, 480);
        Dimension theScreen = Toolkit.getDefaultToolkit().getScreenSize();
        theAppFrame.setLocation((theScreen.width - theAppFrame.getSize().width) / 2, (theScreen.height - theAppFrame.getSize().height) / 2);
        theAppFrame.setVisible(true);
        theApplet.start();
    }

    @Override
    public String getAppletInfo() {
        return new String("JavaPipe - The TunedPipe Applet\nRequires Java 1.7 or higher.\nCopyright \u00a9 1997-2014 Martin Hepperle");
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton theSource = (JButton)e.getSource();
        if (theSource == this.thePrintButton) {
            this.print();
        } else if (theSource == this.theExportButton) {
            JFileChooser theChooser = new JFileChooser();
            theChooser.setDialogTitle("Export Geometry");
            MHFileFilter theFilter = new MHFileFilter();
            theFilter.addExtension("igs");
            theFilter.setDescription("IGES files");
            theChooser.addChoosableFileFilter(theFilter);
            theFilter = new MHFileFilter();
            theFilter.addExtension("dxf");
            theFilter.setDescription("AutoCad DXF files");
            theChooser.addChoosableFileFilter(theFilter);
            theChooser.setCurrentDirectory(new File(this.m_sCurrentPath));
            if (theChooser.showSaveDialog(this) == 0) {
                String sFileName = theChooser.getSelectedFile().getAbsolutePath();
                this.export(sFileName);
                this.m_sCurrentPath = sFileName.substring(0, sFileName.lastIndexOf(File.separator));
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex == 0) {
            Graphics2D g2d = (Graphics2D)g;
            Rectangle2D.Double thePageRect = new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            Dimension thePageSize = thePageRect.getBounds().getSize();
            g2d.setFont(new Font(TunedPipeDesigner.getLocaleFontName(true), 0, 10));
            TunedPipeDesigner.printHeader(g2d, thePageSize, 0, 25, "JavaPipe - Tuned Pipe Design");
            TunedPipeDesigner.printFooter(g2d, thePageSize);
            g2d.translate(0, 30);
            this.m_Pipe.drawPipe(g, new Dimension((int)pf.getImageableWidth(), (int)(pf.getImageableHeight() * 0.3)), false, true);
            g2d.translate(0, 30 + (int)(pf.getImageableHeight() * 0.3));
            g2d.drawString(TunedPipeDesigner.getLocalString("NOTES"), 20, 0);
            g2d.drawString(TunedPipeDesigner.getLocalString("NOTES_1"), 20, 15);
            g2d.drawString(TunedPipeDesigner.getLocalString("NOTES_2"), 20, 30);
            g2d.drawString(TunedPipeDesigner.getLocalString("NOTES_3"), 20, 45);
            return 0;
        }
        if (pageIndex == 1) {
            String sScale;
            Graphics2D g2d = (Graphics2D)g;
            Rectangle2D.Double thePageRect = new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            Dimension thePageSize = thePageRect.getBounds().getSize();
            g2d.setFont(new Font(TunedPipeDesigner.getLocaleFontName(true), 0, 10));
            TunedPipeDesigner.printHeader(g2d, thePageSize, 0, 25, "JavaPipe - Tuned Pipe Design");
            TunedPipeDesigner.printFooter(g2d, thePageSize);
            g2d.translate(0, 40);
            int nRemainder = (int)(pf.getImageableHeight() - 50.0);
            double m2u = 2834.645669291339;
            double wD = this.m_Pipe.Diffusor.getBBoxWidth(m2u);
            double hD = this.m_Pipe.Diffusor.getBBoxHeight(m2u);
            double wR = this.m_Pipe.Reflector.getBBoxWidth(m2u);
            double hR = this.m_Pipe.Reflector.getBBoxHeight(m2u);
            double dRatio = Math.max(Math.max(wD / (pf.getImageableWidth() - 20.0), hD / (double)(nRemainder / 2)), Math.max(wR / (pf.getImageableWidth() - 20.0), hR / (double)(nRemainder / 2)));
            if (dRatio > 1.0) {
                sScale = TunedPipeDesigner.getLocalString("NOS");
                dRatio = m2u / dRatio;
            } else {
                dRatio = m2u;
                sScale = TunedPipeDesigner.getLocalString("11S");
            }
            g2d.drawString(sScale, 0, 10);
            g2d.translate(0.5 * (pf.getImageableWidth() - this.m_Pipe.Diffusor.getBBoxWidth(dRatio)), 0.5 * this.m_Pipe.Diffusor.getBBoxHeight(dRatio));
            this.m_Pipe.Diffusor.drawCone(g2d, dRatio);
            g2d.translate(-0.5 * (pf.getImageableWidth() - this.m_Pipe.Diffusor.getBBoxWidth(dRatio)), 0.5 * this.m_Pipe.Diffusor.getBBoxHeight(dRatio));
            g2d.translate(0, 5);
            g2d.translate(0.5 * (pf.getImageableWidth() - this.m_Pipe.Reflector.getBBoxWidth(dRatio)), 0.5 * this.m_Pipe.Reflector.getBBoxHeight(dRatio));
            this.m_Pipe.Reflector.drawCone(g2d, dRatio);
            return 0;
        }
        return 1;
    }

    public void print() {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(new Copies(1));
        aset.add(new JobName("TunedPipe Designer", null));
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        try {
            if (pj.printDialog(aset)) {
                pj.print(aset);
            }
        }
        catch (PrinterException pe) {
            System.err.println(pe);
        }
    }

    public static int printHeader(Graphics g, Dimension PageDimension, int x, int y, String Caption) {
        Font f = g.getFont();
        g.setFont(new Font(TunedPipeDesigner.getLocaleFontName(true), 0, 14));
        g.drawString(Caption, x, y);
        g.setFont(f);
        g.drawLine(x, y + 4, PageDimension.width - x, y + 4);
        return y + 20;
    }

    public static void printFooter(Graphics g, Dimension PageDimension) {
        String sCopyRight = String.valueOf(TunedPipeDesigner.getLocalString("CREATOR")) + " JavaPipe    \u00a9 1997-2014 Martin Hepperle    http://www.MH-AeroTools.de/";
        Font f = g.getFont();
        g.setFont(new Font(TunedPipeDesigner.getLocaleFontName(true), 0, 9));
        g.drawString(sCopyRight, (PageDimension.width - g.getFontMetrics().stringWidth(sCopyRight)) / 2, PageDimension.height - 5);
        g.setFont(f);
    }

    @Override
    public void setLocale(Locale theLocale) {
        m_Locale = theLocale;
        try {
            m_Bundle = ResourceBundle.getBundle("MH.Localized", theLocale);
        }
        catch (MissingResourceException Exception2) {
            m_Bundle = ResourceBundle.getBundle("MH.Localized");
            this.missingLocaleMessageBox();
        }
    }

    public static String getLocalString(String sKey) {
        return m_Bundle.getString(sKey);
    }

    public static String getLocalUnit(String sKey) {
        return "[" + m_Bundle.getString("UNIT_" + sKey) + "]";
    }

    private void missingLocaleMessageBox() {
        JFrame theFrame = new JFrame();
        JDialog theDialog = new JDialog(theFrame, " Information ", false);
        JButton theOKButton = new JButton(" OK ");
        theDialog.setLayout(new BorderLayout());
        theDialog.add("Center", new TextArea("Your Locale is not yet supported.\n\nI can add support for your Locale, if you\ntranslate a few items into your language.\nPlease translate the file 'Localized.java' in the\nJavaPipe directory and e-mail it to me.\n\nFor now, we use the default Locale (US-English).\n\nMartin.Hepperle@MH-AeroTools.de"));
        theDialog.add("South", theOKButton);
        theDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
            }
        });
        theOKButton.addActionListener(this);
        theDialog.pack();
        Dimension theDialogSize = theDialog.getSize();
        theDialog.setLocation((640 - theDialogSize.width) / 2, (400 - theDialogSize.height) / 2);
        theDialog.setVisible(true);
    }

    private void MessageBox(String sCaption, String sMessage) {
        JFrame theFrame = new JFrame();
        JDialog theDialog = new JDialog(theFrame, sCaption, false);
        theDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
            }
        });
        JButton theOKButton = new JButton(" OK ");
        theOKButton.addActionListener(new MessageBoxListener(theFrame));
        Container theContentPane = theDialog.getContentPane();
        theContentPane.setLayout(new BorderLayout());
        theContentPane.add("Center", new TextArea(sMessage));
        theContentPane.add("South", theOKButton);
        theDialog.pack();
        Dimension theDialogSize = theDialog.getSize();
        theDialog.setLocation((640 - theDialogSize.width) / 2, (400 - theDialogSize.height) / 2);
        theDialog.setVisible(true);
    }

    public void export(String sFileName) {
        if (sFileName != null) {
            String s = sFileName.toLowerCase();
            if (s.endsWith(".dxf")) {
                int i = s.lastIndexOf(".dxf");
                if (i > 0) {
                    sFileName = sFileName.substring(0, i);
                }
                try {
                    BufferedWriter br = new BufferedWriter(new FileWriter(String.valueOf(sFileName) + "-" + TunedPipeDesigner.getLocalString("DIF") + sDXF));
                    br.write(this.m_Pipe.Diffusor.getDXF());
                    br.close();
                    br = new BufferedWriter(new FileWriter(String.valueOf(sFileName) + "-" + TunedPipeDesigner.getLocalString("REF") + sDXF));
                    br.write(this.m_Pipe.Reflector.getDXF());
                    br.close();
                    br = new BufferedWriter(new FileWriter(String.valueOf(sFileName) + "-" + TunedPipeDesigner.getLocalString("SID") + sDXF));
                    br.write(this.m_Pipe.getDXF());
                    br.close();
                }
                catch (IOException iOException) {}
            } else {
                try {
                    BufferedWriter igesWriter = new BufferedWriter(new FileWriter(sFileName));
                    igesWriter.write(this.m_Pipe.getIGES());
                    igesWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static String getLocaleFontName(boolean isPrinting) {
        if (!currentLanguage.equals(m_Locale.getLanguage())) {
            currentLanguage = m_Locale.getLanguage();
            String string = localeFontName = isPrinting ? "Arial Unicode MS" : "SansSerif";
            if (currentLanguage.equals("zh")) {
                localeFontName = "Arial Unicode MS";
                char sampleChineseCharacter = '\u4f60';
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Font[] allFonts = env.getAllFonts();
                if (allFonts != null) {
                    int i = 0;
                    while (i < allFonts.length) {
                        if (allFonts[i].canDisplay(sampleChineseCharacter) && allFonts[i].isPlain()) {
                            localeFontName = allFonts[i].getName();
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        return localeFontName;
    }

    public static boolean isFileIOAllowed() {
        boolean Success = true;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkWrite("write.try");
                security.checkRead("read.try");
            }
            catch (SecurityException e) {
                Success = false;
            }
        }
        return Success;
    }

    private class MessageBoxListener
    implements ActionListener {
        JFrame m_Frame;

        MessageBoxListener(JFrame theFrame) {
            this.m_Frame = theFrame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.m_Frame != null) {
                this.m_Frame.dispose();
            }
        }
    }
}

