/*
 * Decompiled with CFR 0.152.
 */
package MH;

import MH.AeroTools.Util.Iges.entityCircle;
import MH.AeroTools.Util.Iges.igesFile;
import MH.Cone;
import MH.ExportDXF;
import MH.TunedPipeDesigner;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.text.DecimalFormat;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class TunedPipe
extends JPanel {
    public static final int RPM = 0;
    public static final int TRANSFER_ANGLE = 1;
    public static final int EXHAUST_ANGLE = 2;
    public static final int EXHAUST_AREA = 3;
    public static final int EXHAUST_TEMP = 4;
    public static final int METHANOL = 0;
    public static final int GASOLINE = 1;
    private String m_Name = "Tuned Pipe";
    private double dTransferAngle = 130.0;
    private double dExhaustAngle = 175.0;
    private double dExhaustArea = 9.999999999999999E-5;
    private double dDiameter1;
    private double dDiameter2;
    private double dDiameter3;
    private double dHeaderLength;
    private double dDiffusorLength;
    private double dCylinderLength;
    private double dReflectorLength;
    private double dEndpipeLength;
    private double dVelocityOfRotation = 25000.0;
    private double dLength;
    private double dTotalVolume;
    private double dScale;
    private Dimension m_Size;
    private Image m_BackBuffer = null;
    private double m_Temperature = 473.15;
    private int m_FuelType = 0;
    private double[] m_GasConstant = new double[]{311.6, 290.6};
    private double[] m_IsentropEx = new double[]{1.29, 1.33};
    private static String unitMM;
    private static String m_fontName;
    Cone Diffusor;
    Cone Reflector;

    TunedPipe() {
        unitMM = "mm";
        m_fontName = "SansSerif";
        this.CalcGeometry();
    }

    public static void setUnitMM(String unitString) {
        unitMM = unitString;
    }

    public static void setFontName(String fontName) {
        m_fontName = fontName;
    }

    @Override
    public void setName(String Name) {
        this.m_Name = Name;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public String getLength() {
        double dTotalLength = this.dHeaderLength + this.dDiffusorLength + this.dCylinderLength + this.dReflectorLength + this.dEndpipeLength;
        return Double.toString(dTotalLength);
    }

    public String getDiameter() {
        return Double.toString(this.dDiameter2);
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.m_Size = new Dimension(w, h);
        if (this.m_Size.width > 0 && this.m_Size.height > 0) {
            this.m_BackBuffer = this.createImage(this.m_Size.width, this.m_Size.height);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.m_Size.width, this.m_Size.height);
    }

    @Override
    public void paint(Graphics theForeBuffer) {
        if (this.m_BackBuffer != null) {
            Graphics g = this.m_BackBuffer.getGraphics();
            this.drawPipe(g, this.m_Size, true, false);
            theForeBuffer.drawImage(this.m_BackBuffer, 0, 0, null);
            g.dispose();
        } else {
            this.drawPipe(theForeBuffer, this.m_Size, true, false);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void drawPipe(Graphics g, Dimension theSize, boolean fillBackground, boolean isPrinting) {
        DecimalFormat theFormat = new DecimalFormat();
        theFormat.setMaximumFractionDigits(1);
        theFormat.setMinimumFractionDigits(1);
        Font savedFont = g.getFont();
        if (fillBackground && !isPrinting) {
            Color theColor = new Color(0.85f, 0.9f, 0.95f);
            g.setColor(theColor);
            Graphics2D g2 = (Graphics2D)g;
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, theColor, 0.0f, theSize.height * 6 / 10, Color.white, true);
            g2.setPaint(gp);
            g2.fillRect(0, 0, theSize.width, theSize.height);
            g2.draw3DRect(0, 0, theSize.width - 1, theSize.height - 1, false);
            g2.draw3DRect(1, 1, theSize.width - 3, theSize.height - 3, true);
        }
        if (this.dLength <= 0.01) {
            return;
        }
        this.dScale = 0.9 * (double)theSize.width / (this.dLength + 0.5 * this.dReflectorLength + this.dEndpipeLength);
        g.translate((int)(0.05 * (double)theSize.width), (int)(0.5 * (double)theSize.height));
        int x0 = 0;
        int x1 = (int)(this.dScale * this.dHeaderLength);
        int x2 = (int)(this.dScale * (this.dHeaderLength + this.dDiffusorLength));
        int x3 = (int)(this.dScale * (this.dLength - 0.5 * this.dReflectorLength));
        int x4 = (int)(this.dScale * (this.dLength + 0.5 * this.dReflectorLength));
        int x5 = x4 + (int)(this.dScale * this.dEndpipeLength);
        int y1 = (int)(this.dScale * this.dDiameter1 * 0.5);
        int y3 = (int)(this.dScale * this.dDiameter2 * 0.5);
        int y5 = (int)(this.dScale * this.dDiameter3 * 0.5);
        Polygon polygon1 = new Polygon();
        polygon1.addPoint(x0 + 1, y1);
        polygon1.addPoint(x1, y1);
        polygon1.addPoint(x1, -y1);
        polygon1.addPoint(x0 + 1, -y1);
        polygon1.addPoint(x0 + 1, y1);
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(x1 + 1, y1);
        polygon2.addPoint(x2, y3);
        polygon2.addPoint(x2, -y3);
        polygon2.addPoint(x1 + 1, -y1);
        polygon2.addPoint(x1 + 1, y1);
        Polygon polygon3 = new Polygon();
        polygon3.addPoint(x2 + 1, y3);
        polygon3.addPoint(x3, y3);
        polygon3.addPoint(x3, -y3);
        polygon3.addPoint(x2 + 1, -y3);
        polygon3.addPoint(x2 + 1, y3);
        Polygon polygon4 = new Polygon();
        polygon4.addPoint(x3 + 1, y3);
        polygon4.addPoint(x4, y5);
        polygon4.addPoint(x4, -y5);
        polygon4.addPoint(x3 + 1, -y3);
        polygon4.addPoint(x3 + 1, y3);
        Polygon polygon5 = new Polygon();
        polygon5.addPoint(x4 + 1, y5);
        polygon5.addPoint(x5, y5);
        polygon5.addPoint(x5, -y5);
        polygon5.addPoint(x4 + 1, -y5);
        polygon5.addPoint(x4 + 1, y5);
        if (isPrinting) {
            g.setColor(Color.gray);
            g.fillPolygon(polygon1);
            g.fillPolygon(polygon2);
            g.fillPolygon(polygon3);
            g.fillPolygon(polygon4);
            g.fillPolygon(polygon5);
            g.setColor(Color.lightGray);
            g.drawLine(x0 + 2, -y1 * 7 / 8, x1 - 2, -y1 * 7 / 8);
            g.drawLine(x1 + 2, -y1 * 7 / 8, x2 - 2, -y3 * 7 / 8);
            g.drawLine(x2 + 2, -y3 * 7 / 8, x3 - 2, -y3 * 7 / 8);
            g.drawLine(x3 + 2, -y3 * 7 / 8, x4 - 2, -y5 * 7 / 8);
            g.drawLine(x4 + 2, -y5 * 7 / 8, x5 - 2, -y5 * 7 / 8);
            g.drawLine(x0 + 2, -y1 * 5 / 8, x1 - 2, -y1 * 5 / 8);
            g.drawLine(x1 + 2, -y1 * 5 / 8, x2 - 2, -y3 * 5 / 8);
            g.drawLine(x2 + 2, -y3 * 5 / 8, x3 - 2, -y3 * 5 / 8);
            g.drawLine(x3 + 2, -y3 * 5 / 8, x4 - 2, -y5 * 5 / 8);
            g.drawLine(x4 + 2, -y5 * 5 / 8, x5 - 2, -y5 * 5 / 8);
            g.setColor(Color.white);
            g.drawLine(x0 + 2, -y1 * 6 / 8, x1 - 2, -y1 * 6 / 8);
            g.drawLine(x1 + 2, -y1 * 6 / 8, x2 - 2, -y3 * 6 / 8);
            g.drawLine(x2 + 2, -y3 * 6 / 8, x3 - 2, -y3 * 6 / 8);
            g.drawLine(x3 + 2, -y3 * 6 / 8, x4 - 2, -y5 * 6 / 8);
            g.drawLine(x4 + 2, -y5 * 6 / 8, x5 - 2, -y5 * 6 / 8);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            GradientPaint gp = new GradientPaint(x1, 0.0f, Color.lightGray, x1, y1, Color.darkGray, true);
            g2.setPaint(gp);
            g2.fillPolygon(polygon1);
            gp = new GradientPaint(x1, 0.0f, Color.lightGray, x1, y3, Color.darkGray, true);
            g2.setPaint(gp);
            g2.fillPolygon(polygon2);
            g2.fillPolygon(polygon3);
            g2.fillPolygon(polygon4);
            gp = new GradientPaint(x1, 0.0f, Color.lightGray, x1, y5, Color.darkGray, true);
            g2.setPaint(gp);
            g2.fillPolygon(polygon5);
        }
        FontMetrics fm = g.getFontMetrics();
        TunedPipe.DrawHorzDim(g, x0, x1, y3 * 3 / 2, this.dHeaderLength * 1000.0);
        TunedPipe.DrawHorzDim(g, x1, x2, y3 * 3 / 2, this.dDiffusorLength * 1000.0);
        TunedPipe.DrawHorzDim(g, x2, x3, y3 * 3 / 2, this.dCylinderLength * 1000.0);
        TunedPipe.DrawHorzDim(g, x3, x4, y3 * 3 / 2, this.dReflectorLength * 1000.0);
        TunedPipe.DrawHorzDim(g, x4, x5, y3 * 3 / 2, this.dEndpipeLength * 1000.0);
        TunedPipe.DrawHorzDim(g, x0, x5, y3 * 4 / 2 + fm.getHeight(), (this.dHeaderLength + this.dDiffusorLength + this.dCylinderLength + this.dReflectorLength + this.dEndpipeLength) * 1000.0);
        TunedPipe.DrawDiaDim(g, x1 / 2, y3 * 3 / 2, this.dDiameter1 * 1000.0);
        TunedPipe.DrawDiaDim(g, (x2 + x3) / 2, y3 * 3 / 2, this.dDiameter2 * 1000.0);
        TunedPipe.DrawDiaDim(g, (x4 + x5) / 2, y3 * 3 / 2, this.dDiameter3 * 1000.0);
        String strPlanform = "R = " + theFormat.format(this.Diffusor.getR1() * 1000.0) + " / " + theFormat.format(this.Diffusor.getR2() * 1000.0) + " " + unitMM;
        g.drawString(strPlanform, (x1 + x2 - fm.stringWidth(strPlanform)) / 2, (int)(0.45 * (double)theSize.height) - fm.getHeight());
        strPlanform = "\u03c6 =" + theFormat.format(this.Diffusor.getPhiDeg()) + "\u00b0";
        g.drawString(strPlanform, (x1 + x2 - fm.stringWidth(strPlanform)) / 2, (int)(0.45 * (double)theSize.height));
        strPlanform = "R = " + theFormat.format(this.Reflector.getR1() * 1000.0) + " / " + theFormat.format(this.Reflector.getR2() * 1000.0) + " " + unitMM;
        g.drawString(strPlanform, (x3 + x4 - fm.stringWidth(strPlanform)) / 2, (int)(0.45 * (double)theSize.height) - fm.getHeight());
        strPlanform = "\u03c6 =" + theFormat.format(this.Reflector.getPhiDeg()) + "\u00b0";
        g.drawString(strPlanform, (x3 + x4 - fm.stringWidth(strPlanform)) / 2, (int)(0.45 * (double)theSize.height));
        g.setColor(Color.blue);
        g.setFont(new Font(m_fontName, 0, 11));
        fm = g.getFontMetrics();
        g.translate(-((int)(0.05 * (double)theSize.width)), -((int)(0.5 * (double)theSize.height)));
        String strVolume = new String(String.valueOf(TunedPipeDesigner.getLocalString("VOL")) + " = " + theFormat.format(this.dTotalVolume * 1000000.0) + " cm\u00b3");
        g.drawString(strVolume, (theSize.width - fm.stringWidth(strVolume)) / 2, fm.getHeight());
        double dDisplacement = this.dTotalVolume / 18.0 * 1000000.0;
        strVolume = new String(String.valueOf(TunedPipeDesigner.getLocalString("DISPL")) + " = " + theFormat.format(dDisplacement * 0.8) + "..." + theFormat.format(dDisplacement * 1.4) + " cm\u00b3");
        g.drawString(strVolume, (theSize.width - fm.stringWidth(strVolume)) / 2, 2 * fm.getHeight());
        g.setColor(Color.cyan.darker());
        g.setFont(g.getFont().deriveFont(2, 9.0f));
        fm = g.getFontMetrics();
        String sCopyright = "\u00a9 1997-2014 Martin Hepperle";
        g.drawString(sCopyright, theSize.width - fm.stringWidth(sCopyright) - 4, fm.getHeight());
        g.setColor(Color.blue);
        g.setFont(savedFont);
    }

    public void setRPM(double dRPM) {
        this.dVelocityOfRotation = dRPM;
        this.CalcGeometry();
        this.repaint();
    }

    public void setTransferAngle(double dAngle) {
        this.dTransferAngle = dAngle;
        this.CalcGeometry();
        this.repaint();
    }

    public void setExhaustAngle(double dAngle) {
        this.dExhaustAngle = dAngle;
        this.CalcGeometry();
        this.repaint();
    }

    public void setExhaustArea(double dArea) {
        this.dExhaustArea = dArea / 1000000.0;
        this.CalcGeometry();
        this.repaint();
    }

    public double setExhaustTemperature(double dTemperature) {
        if (dTemperature < 400.0) {
            dTemperature += 273.15;
            JOptionPane.showMessageDialog(this, TunedPipeDesigner.getLocalString("TEMP_K_C"), TunedPipeDesigner.getLocalString("ERR_K_C"), 1);
        }
        this.m_Temperature = dTemperature;
        this.CalcGeometry();
        this.repaint();
        return dTemperature;
    }

    public void setFuelType(int FuelType) {
        this.m_FuelType = FuelType;
        this.CalcGeometry();
        this.repaint();
    }

    private void CalcGeometry() {
        double dSpeedOfSound = Math.sqrt(this.m_IsentropEx[this.m_FuelType] * this.m_GasConstant[this.m_FuelType] * this.m_Temperature);
        this.dLength = 60.0 * dSpeedOfSound / (2.0 * this.dVelocityOfRotation) * (this.dExhaustAngle - 0.5 * (this.dExhaustAngle - this.dTransferAngle)) / 360.0;
        this.dDiameter1 = Math.sqrt(2.15 * this.dExhaustArea);
        this.dDiameter2 = Math.sqrt(12.5 * this.dExhaustArea);
        this.dDiameter3 = Math.sqrt(0.75 * this.dExhaustArea);
        this.dDiffusorLength = 0.5 * (this.dDiameter2 - this.dDiameter1) / Math.tan(0.06);
        this.dReflectorLength = 0.5 * (this.dDiameter2 - this.dDiameter3) / Math.tan(0.13);
        this.dHeaderLength = 0.3 * this.dLength;
        this.dEndpipeLength = this.dDiameter3 * (1.0 + 0.5 / Math.tan(0.1309));
        if (this.dHeaderLength > this.dDiffusorLength) {
            double d1 = this.dHeaderLength + this.dDiffusorLength;
            this.dHeaderLength = 0.4 * d1;
            this.dDiffusorLength = 0.6 * d1;
        }
        this.dCylinderLength = this.dLength - this.dHeaderLength - this.dDiffusorLength - this.dReflectorLength * 0.5;
        if (this.dCylinderLength <= 0.0) {
            this.dHeaderLength += this.dCylinderLength;
            this.dCylinderLength = 0.0;
        }
        if (this.dHeaderLength <= 0.0) {
            this.dDiffusorLength += this.dHeaderLength;
            this.dHeaderLength = 0.0;
        }
        double d2 = 0.7853981633974483 * this.dDiameter1 * this.dDiameter1 * this.dHeaderLength;
        double d3 = 0.7853981633974483 * this.dDiameter2 * this.dDiameter2 * this.dCylinderLength;
        double d4 = 0.7853981633974483 * this.dDiameter3 * this.dDiameter3 * this.dEndpipeLength;
        double d5 = 0.2617993877991494 * (this.dDiameter1 * this.dDiameter1 + this.dDiameter1 * this.dDiameter2 + this.dDiameter2 * this.dDiameter2) * this.dDiffusorLength;
        double d6 = 0.2617993877991494 * (this.dDiameter2 * this.dDiameter2 + this.dDiameter2 * this.dDiameter3 + this.dDiameter3 * this.dDiameter3) * this.dReflectorLength;
        this.dTotalVolume = d2 + d5 + d3 + d6 + d4;
        this.Diffusor = new Cone(TunedPipeDesigner.getLocalString("DIF"), this.dDiffusorLength, this.dDiameter1, this.dDiameter2);
        Cone.setUnitMM(unitMM);
        this.Reflector = new Cone(TunedPipeDesigner.getLocalString("REF"), this.dReflectorLength, this.dDiameter3, this.dDiameter2);
        Cone.setUnitMM(unitMM);
    }

    static void DrawHorzDim(Graphics g, int x1, int x2, int y, double d) {
        if (d < 1.0) {
            return;
        }
        String string = String.valueOf((int)(d + 0.5)) + " " + unitMM;
        g.setColor(Color.blue);
        Font savedFont = g.getFont();
        g.setFont(new Font(m_fontName, 0, 10));
        int x4 = g.getFontMetrics().stringWidth(string);
        int x5 = g.getFontMetrics().getHeight();
        g.drawLine(x1, 0, x1, y + 2);
        g.drawLine(x2, 0, x2, y + 2);
        g.drawLine(x1, y, x2, y);
        g.drawString(string, (x1 + x2 - x4) / 2, y + x5 * 8 / 10);
        int[] xa = new int[3];
        int[] ya = new int[3];
        xa[0] = x1;
        ya[0] = y;
        xa[1] = x1 + x5;
        ya[1] = y - x5 / 5;
        xa[2] = x1 + x5;
        ya[2] = y + x5 / 5;
        g.fillPolygon(xa, ya, 3);
        g.drawPolygon(xa, ya, 3);
        xa[0] = x2;
        xa[1] = x2 - x5;
        xa[2] = x2 - x5;
        g.fillPolygon(xa, ya, 3);
        g.drawPolygon(xa, ya, 3);
        g.setFont(savedFont);
    }

    static void DrawDiaDim(Graphics g, int nX, int nY, double d) {
        if (d > 1.0) {
            String string = "\u00d8 " + (int)(d + 0.5) + " " + unitMM;
            g.setColor(Color.blue);
            Font savedFont = g.getFont();
            g.setFont(new Font(m_fontName, 0, 10));
            int nWidth = g.getFontMetrics().stringWidth(string);
            int nHeight = g.getFontMetrics().getHeight();
            g.drawLine(nX, 0, nX, -nY);
            g.fillOval(nX - nHeight / 6, 0 - nHeight / 6, nHeight / 3, nHeight / 3);
            if ((nX -= nWidth / 2) < 1) {
                nX = 1;
            }
            g.drawString(string, nX, -nY - nHeight / 2);
            g.setFont(savedFont);
        }
    }

    public String getDXF() {
        double dScale = 1000.0;
        ExportDXF theDXF = new ExportDXF(-0.001 * dScale, (this.dHeaderLength + this.dDiffusorLength + this.dCylinderLength + this.dReflectorLength + this.dEndpipeLength + 0.001) * dScale, -(this.dDiameter2 + 0.001) * dScale, (this.dDiameter2 + 0.001) * dScale);
        double x0 = 0.0;
        double x1 = dScale * this.dHeaderLength;
        double x2 = dScale * (this.dHeaderLength + this.dDiffusorLength);
        double x3 = dScale * (this.dLength - 0.5 * this.dReflectorLength);
        double x4 = dScale * (this.dLength + 0.5 * this.dReflectorLength);
        double x5 = x4 + dScale * this.dEndpipeLength;
        double y1 = dScale * this.dDiameter1 * 0.5;
        double y3 = dScale * this.dDiameter2 * 0.5;
        double y5 = dScale * this.dDiameter3 * 0.5;
        theDXF.beginPolygon();
        theDXF.addPolygonPoint(x0, -y1);
        theDXF.addPolygonPoint(x0, y1);
        theDXF.addPolygonPoint(x1, y1);
        theDXF.addPolygonPoint(x1, -y1);
        theDXF.addPolygonPoint(x0, -y1);
        theDXF.endPolygon();
        theDXF.beginPolygon();
        theDXF.addPolygonPoint(x1, -y1);
        theDXF.addPolygonPoint(x1, y1);
        theDXF.addPolygonPoint(x2, y3);
        theDXF.addPolygonPoint(x2, -y3);
        theDXF.addPolygonPoint(x1, -y1);
        theDXF.endPolygon();
        theDXF.beginPolygon();
        theDXF.addPolygonPoint(x2, -y3);
        theDXF.addPolygonPoint(x2, y3);
        theDXF.addPolygonPoint(x3, y3);
        theDXF.addPolygonPoint(x3, -y3);
        theDXF.addPolygonPoint(x2, -y3);
        theDXF.endPolygon();
        theDXF.beginPolygon();
        theDXF.addPolygonPoint(x3, -y3);
        theDXF.addPolygonPoint(x3, y3);
        theDXF.addPolygonPoint(x4, y5);
        theDXF.addPolygonPoint(x4, -y5);
        theDXF.addPolygonPoint(x3, -y3);
        theDXF.endPolygon();
        theDXF.beginPolygon();
        theDXF.addPolygonPoint(x4, -y5);
        theDXF.addPolygonPoint(x4, y5);
        theDXF.addPolygonPoint(x5, y5);
        theDXF.addPolygonPoint(x5, -y5);
        theDXF.addPolygonPoint(x4, -y5);
        theDXF.endPolygon();
        theDXF.beginPolygon();
        theDXF.addPolygonPoint(x0, 0.0);
        theDXF.addPolygonPoint(x4, 0.0);
        theDXF.endPolygon();
        return theDXF.getDXF();
    }

    public String getIGES() {
        igesFile f = new igesFile();
        entityCircle c = new entityCircle(0.0, 0.0, 0.0, this.dDiameter1, 2);
        f.addEntity(c);
        if (this.dHeaderLength > 0.0) {
            c = new entityCircle(this.dHeaderLength, 0.0, 0.0, this.dDiameter1, 2);
            f.addEntity(c);
        }
        c = new entityCircle(this.dHeaderLength + this.dDiffusorLength, 0.0, 0.0, this.dDiameter2, 2);
        f.addEntity(c);
        if (this.dCylinderLength > 0.0) {
            c = new entityCircle(this.dHeaderLength + this.dDiffusorLength + this.dCylinderLength, 0.0, 0.0, this.dDiameter2, 2);
            f.addEntity(c);
        }
        c = new entityCircle(this.dHeaderLength + this.dDiffusorLength + this.dCylinderLength + this.dReflectorLength, 0.0, 0.0, this.dDiameter3, 2);
        f.addEntity(c);
        c = new entityCircle(this.dHeaderLength + this.dDiffusorLength + this.dCylinderLength + this.dReflectorLength + this.dEndpipeLength, 0.0, 0.0, this.dDiameter3, 2);
        f.addEntity(c);
        return f.toString();
    }
}

