/*
 * Decompiled with CFR 0.152.
 */
package MH;

import MH.TunedPipe;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.DecimalFormat;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

class InstantScrollbar
extends JScrollBar
implements AdjustmentListener {
    private JTextField m_TextField;
    private TunedPipe thePipe;
    private int m_Ident;

    InstantScrollbar(int Value, int Step, int Minimum, int Maximum, int nIdent, JTextField textField, TunedPipe tunedPipe) {
        super(0, Value, Step, Minimum, Maximum + Step);
        this.setBlockIncrement(Step);
        this.m_Ident = nIdent;
        this.thePipe = tunedPipe;
        this.m_TextField = textField;
        this.addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        DecimalFormat theFormat = new DecimalFormat();
        theFormat.setGroupingUsed(false);
        theFormat.setMaximumFractionDigits(0);
        theFormat.setMinimumFractionDigits(0);
        float f = super.getValue();
        switch (this.m_Ident) {
            case 0: {
                this.thePipe.setRPM(f);
                break;
            }
            case 1: {
                this.thePipe.setTransferAngle(f);
                break;
            }
            case 2: {
                this.thePipe.setExhaustAngle(f);
                break;
            }
            case 3: {
                this.thePipe.setExhaustArea(f);
                break;
            }
            case 4: {
                this.thePipe.setExhaustTemperature(f);
            }
        }
        this.m_TextField.setText(theFormat.format(f));
    }
}

