/*
 * Decompiled with CFR 0.152.
 */
package MH;

import java.text.NumberFormat;
import java.util.Locale;

public class ExportDXF {
    private StringBuffer sb;
    private NumberFormat theFormat = NumberFormat.getNumberInstance(Locale.US);
    String sNewLine;

    ExportDXF(double xMin, double xMax, double yMin, double yMax) {
        this.theFormat.setMaximumFractionDigits(6);
        this.theFormat.setMinimumFractionDigits(6);
        try {
            this.sNewLine = System.getProperty("line.separator");
        }
        catch (SecurityException theException) {
            this.sNewLine = this.sNewLine;
        }
        this.sb = new StringBuffer();
        this.sb.append("  0" + this.sNewLine + "SECTION" + this.sNewLine + "  2" + this.sNewLine + "HEADER" + this.sNewLine + "  9" + this.sNewLine + "$EXTMIN" + this.sNewLine);
        this.sb.append(" 10" + this.sNewLine + this.theFormat.format(xMin) + this.sNewLine);
        this.sb.append(" 20" + this.sNewLine + this.theFormat.format(yMin) + this.sNewLine);
        this.sb.append("  9" + this.sNewLine + "$EXTMAX" + this.sNewLine);
        this.sb.append(" 10" + this.sNewLine + this.theFormat.format(xMax) + this.sNewLine);
        this.sb.append(" 20" + this.sNewLine + this.theFormat.format(yMax) + this.sNewLine);
        this.sb.append("  0" + this.sNewLine + "ENDSEC" + this.sNewLine + "  0" + this.sNewLine + "SECTION" + this.sNewLine + "  2" + this.sNewLine + "TABLES" + this.sNewLine + "  0" + this.sNewLine + "ENDSEC" + this.sNewLine);
        this.sb.append("  0" + this.sNewLine + "SECTION" + this.sNewLine + "  2" + this.sNewLine + "ENTITIES" + this.sNewLine);
    }

    public void beginPolygon() {
        this.sb.append("  0" + this.sNewLine + "POLYLINE" + this.sNewLine + "  8" + this.sNewLine + "0" + this.sNewLine + " 66" + this.sNewLine + "     1" + this.sNewLine);
    }

    public void addPolygonPoint(double x, double y) {
        this.sb.append("  0" + this.sNewLine + "VERTEX" + this.sNewLine + "  8" + this.sNewLine + "0" + this.sNewLine);
        this.sb.append(" 10" + this.sNewLine + this.theFormat.format(x) + this.sNewLine);
        this.sb.append(" 20" + this.sNewLine + this.theFormat.format(y) + this.sNewLine);
    }

    public void endPolygon() {
        this.sb.append("  0" + this.sNewLine + "SEQEND" + this.sNewLine + "  8" + this.sNewLine + "0" + this.sNewLine);
    }

    public void addArc(double xCenter, double yCenter, double Radius, double Start, double Span, int Steps, boolean Append) {
        double PhiStep = Span / (double)Steps;
        double Phi = Start;
        if (!Append) {
            this.beginPolygon();
        }
        int i = 0;
        while (i <= Steps) {
            this.addPolygonPoint(xCenter + Radius * Math.cos(Phi), yCenter + Radius * Math.sin(Phi));
            Phi += PhiStep;
            ++i;
        }
        if (!Append) {
            this.endPolygon();
        }
    }

    public String getDXF() {
        return String.valueOf(this.sb.toString()) + "  0" + this.sNewLine + "ENDSEC" + this.sNewLine + "  0" + this.sNewLine + "EOF" + this.sNewLine;
    }
}

