/*
 * Decompiled with CFR 0.152.
 */
package MH;

import MH.ExportDXF;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;

public class Cone {
    private double m_Phi;
    private double m_R1;
    private double m_R2;
    private double m_Length;
    private String m_Name;
    private static String unitMM;

    Cone(String Name, double Length, double Dia1, double Dia2) {
        this.m_Name = Name;
        this.m_Phi = Math.PI * (Dia2 - Dia1) / Math.sqrt(Math.pow(Length, 2.0) + Math.pow((Dia2 - Dia1) / 2.0, 2.0));
        this.m_R1 = Math.PI * Dia1 / this.m_Phi;
        this.m_R2 = Math.PI * Dia2 / this.m_Phi;
        this.m_Length = Length;
        unitMM = "mm";
    }

    public static void setUnitMM(String unitString) {
        unitMM = unitString;
    }

    public double getBBoxWidth(double dScale) {
        return dScale * (this.m_R2 - this.m_R1 * Math.cos(this.m_Phi / 2.0));
    }

    public double getBBoxHeight(double dScale) {
        return dScale * 2.0 * this.m_R2 * Math.sin(this.m_Phi / 2.0);
    }

    public double getPhiDeg() {
        return Math.toDegrees(this.m_Phi);
    }

    public double getR1() {
        return this.m_R1;
    }

    public double getR2() {
        return this.m_R2;
    }

    public void drawCone(Graphics2D g, double dScale) {
        DecimalFormat theFormat = new DecimalFormat();
        theFormat.setMaximumFractionDigits(1);
        theFormat.setMinimumFractionDigits(1);
        FontMetrics fm = g.getFontMetrics();
        double dXOffset = dScale * this.m_R1 * Math.cos(this.m_Phi / 2.0);
        g.translate(-dXOffset, 0.0);
        g.draw(new Arc2D.Double(-this.m_R1 * dScale, -this.m_R1 * dScale, 2.0 * this.m_R1 * dScale, 2.0 * this.m_R1 * dScale, Math.toDegrees(-this.m_Phi / 2.0), Math.toDegrees(this.m_Phi), 0));
        g.draw(new Arc2D.Double(-this.m_R2 * dScale, -this.m_R2 * dScale, 2.0 * this.m_R2 * dScale, 2.0 * this.m_R2 * dScale, Math.toDegrees(-this.m_Phi / 2.0), Math.toDegrees(this.m_Phi), 0));
        String sAngle = "\u03c6 =" + theFormat.format(this.getPhiDeg()) + "\u00b0";
        g.drawString(sAngle, (int)(this.m_R1 * dScale) + 5, g.getFontMetrics().getHeight() / 2);
        String sR = "R1 = " + theFormat.format(this.m_R1 * 1000.0) + " " + unitMM + " ";
        g.rotate(-1.5707963267948966 + this.m_Phi / 2.0, dScale * this.m_R1 * Math.cos(this.m_Phi / 2.0), dScale * this.m_R1 * Math.sin(this.m_Phi / 2.0));
        g.drawString(sR, (int)(dScale * this.m_R1 * Math.cos(this.m_Phi / 2.0)) - fm.stringWidth(sR), (int)(dScale * this.m_R1 * Math.sin(this.m_Phi / 2.0) + (double)fm.getAscent()));
        g.rotate(1.5707963267948966 - this.m_Phi / 2.0, dScale * this.m_R1 * Math.cos(this.m_Phi / 2.0), dScale * this.m_R1 * Math.sin(this.m_Phi / 2.0));
        sR = "R2 = " + theFormat.format(this.m_R2 * 1000.0) + " " + unitMM + " ";
        g.rotate(-1.5707963267948966 + this.m_Phi / 2.0, dScale * this.m_R2 * Math.cos(this.m_Phi / 2.0), dScale * this.m_R2 * Math.sin(this.m_Phi / 2.0));
        g.drawString(sR, (int)(dScale * this.m_R2 * Math.cos(this.m_Phi / 2.0)) - fm.stringWidth(sR), (int)(dScale * this.m_R2 * Math.sin(this.m_Phi / 2.0) - (double)(fm.getAscent() / 2)));
        g.rotate(1.5707963267948966 - this.m_Phi / 2.0, dScale * this.m_R2 * Math.cos(this.m_Phi / 2.0), dScale * this.m_R2 * Math.sin(this.m_Phi / 2.0));
        g.draw(new Line2D.Double(this.m_R1 * dScale * Math.cos(this.m_Phi / 2.0), this.m_R1 * dScale * Math.sin(this.m_Phi / 2.0), this.m_R2 * dScale * Math.cos(this.m_Phi / 2.0), this.m_R2 * dScale * Math.sin(this.m_Phi / 2.0)));
        g.draw(new Line2D.Double(this.m_R1 * dScale * Math.cos(this.m_Phi / 2.0), -this.m_R1 * dScale * Math.sin(this.m_Phi / 2.0), this.m_R2 * dScale * Math.cos(this.m_Phi / 2.0), -this.m_R2 * dScale * Math.sin(this.m_Phi / 2.0)));
        g.drawString(this.m_Name, (int)(0.5 * ((this.m_R1 + this.m_R2) * dScale - (double)fm.stringWidth(this.m_Name))), fm.getHeight() / 2);
        g.translate(dXOffset, 0.0);
    }

    public String getDXF() {
        double dScale = 1000.0;
        ExportDXF theDXF = new ExportDXF(-0.001 * dScale, this.m_Length * dScale, -this.m_R2 * dScale * Math.sin(this.m_Phi / 2.0), this.m_R2 * dScale * Math.sin(this.m_Phi / 2.0));
        theDXF.beginPolygon();
        theDXF.addPolygonPoint(this.m_R1 * dScale * Math.cos(this.m_Phi / 2.0), this.m_R1 * dScale * Math.sin(this.m_Phi / 2.0));
        theDXF.addPolygonPoint(this.m_R2 * dScale * Math.cos(this.m_Phi / 2.0), this.m_R2 * dScale * Math.sin(this.m_Phi / 2.0));
        theDXF.addArc(0.0, 0.0, this.m_R2 * dScale, this.m_Phi / 2.0, -this.m_Phi, 20, true);
        theDXF.addPolygonPoint(this.m_R1 * dScale * Math.cos(this.m_Phi / 2.0), -this.m_R1 * dScale * Math.sin(this.m_Phi / 2.0));
        theDXF.addArc(0.0, 0.0, this.m_R1 * dScale, -this.m_Phi / 2.0, this.m_Phi, 20, true);
        theDXF.endPolygon();
        return theDXF.getDXF();
    }
}

