/*
 * Decompiled with CFR 0.152.
 */
package MH.AeroTools.Util.Iges;

import MH.AeroTools.Util.Iges.igesEntity;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class igesFile {
    private int m_StartLineCount = 7;
    private int m_GlobalLineCount = 3;
    private int m_DirectoryIndex = 1;
    private StringBuffer m_DirectoryBlock = new StringBuffer();
    private StringBuffer m_DirectoryLine = new StringBuffer();
    private int m_ParameterIndex = 1;
    private StringBuffer m_ParameterBlock = new StringBuffer();
    private StringBuffer m_ParameterLine = new StringBuffer();
    static String m_Header = "/**********************************************************************/S      1\n                                                                        S      2\n   MH Classes - IGES EXPORT                                             S      3\n                                                                        S      4\n   Version 1.0,  10 Oct 2009,  Martin Hepperle                          S      5\n   Version 1.1,  26 May 2013,  Martin Hepperle                          S      6\n                                                                        S      7\n/**********************************************************************/S      8\n1H,,1H;,15HMartin Hepperle,8HGeometry,11HIGES Export,3H1.0,             G      1\n16,15,48,30,96,11HIGES Import,1.,2,2HMM,4,.7,13H090101.000000,.100E-03, G      2\n1000.0,19HDr. Martin Hepperle,12HMH AeroTools,5,2,;                     G      3\n";

    private String alignRight(String token, int width) {
        String sRetVal = "";
        int iFill = width - token.length();
        while (iFill-- > 0) {
            sRetVal = String.valueOf(sRetVal) + " ";
        }
        return String.valueOf(sRetVal) + token;
    }

    protected int addToDirectoryBlock(char cType, int entityType, int formNumber, int startParamIndex, int parameterLineCount) {
        DecimalFormat nn = new DecimalFormat("0", new DecimalFormatSymbols(Locale.US));
        int structure = 0;
        int linePattern = 0;
        int level = 0;
        int view = 0;
        int trafo = 0;
        int label = 0;
        int status = 0;
        this.m_DirectoryLine.append(this.alignRight(nn.format(entityType), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(startParamIndex), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(structure), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(linePattern), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(level), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(view), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(trafo), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(label), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(status), 8));
        nn.setMinimumIntegerDigits(7);
        this.m_DirectoryLine.append("D" + nn.format(this.m_DirectoryIndex));
        nn.setMinimumIntegerDigits(1);
        this.m_DirectoryLine.append("\n");
        this.flushDirectoryLine();
        int lineWeight = 0;
        int colorNumber = 0;
        int reserved = 0;
        int entitySubscript = 0;
        this.m_DirectoryLine.append(this.alignRight(nn.format(entityType), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(lineWeight), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(colorNumber), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(parameterLineCount), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(formNumber), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(reserved), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(reserved), 8));
        this.m_DirectoryLine.append(this.alignRight(String.valueOf(cType) + "_" + nn.format(this.m_DirectoryIndex / 2), 8));
        this.m_DirectoryLine.append(this.alignRight(nn.format(entitySubscript), 8));
        nn.setMinimumIntegerDigits(7);
        this.m_DirectoryLine.append("D" + nn.format(this.m_DirectoryIndex));
        nn.setMinimumIntegerDigits(1);
        this.m_DirectoryLine.append("\n");
        this.flushDirectoryLine();
        return this.m_DirectoryIndex - 1;
    }

    protected void flushDirectoryLine() {
        this.m_DirectoryBlock.append(this.m_DirectoryLine);
        this.m_DirectoryLine = new StringBuffer();
        ++this.m_DirectoryIndex;
    }

    protected int getParamIndex() {
        return this.m_ParameterIndex;
    }

    protected void addToParamBlock(String pToken) {
        if (this.m_ParameterLine.length() + pToken.length() >= 64) {
            this.flushParameterLine();
        }
        this.m_ParameterLine.append(pToken);
    }

    public void flushParameterLine() {
        if (this.m_ParameterLine.length() > 0) {
            while (this.m_ParameterLine.length() < 64) {
                this.m_ParameterLine.append(" ");
            }
            this.m_ParameterBlock.append(this.m_ParameterLine);
            DecimalFormat nn = new DecimalFormat("0", new DecimalFormatSymbols(Locale.US));
            this.m_ParameterBlock.append(this.alignRight(nn.format(this.m_DirectoryIndex), 8));
            nn.setMinimumIntegerDigits(7);
            this.m_ParameterBlock.append("P");
            this.m_ParameterBlock.append(nn.format(this.m_ParameterIndex));
            this.m_ParameterBlock.append("\n");
            this.m_ParameterLine = new StringBuffer();
            ++this.m_ParameterIndex;
        }
    }

    private String getHeaderBlock() {
        SimpleDateFormat df = new SimpleDateFormat("yyMMdd.hhmmss");
        String sDate = df.format(new Date());
        return m_Header.replace("13H090101.000000", "13H" + sDate);
    }

    private String getTerminatorBlock() {
        StringBuffer sb = new StringBuffer();
        DecimalFormat nn = new DecimalFormat("0000000", new DecimalFormatSymbols(Locale.US));
        sb.append("S");
        sb.append(nn.format(this.m_StartLineCount));
        sb.append("G");
        sb.append(nn.format(this.m_GlobalLineCount));
        sb.append("D");
        sb.append(nn.format(this.m_DirectoryIndex - 1));
        sb.append("P");
        sb.append(nn.format(this.m_ParameterIndex - 1));
        sb.append("        ");
        sb.append("        ");
        sb.append("        ");
        sb.append("        ");
        sb.append("        ");
        sb.append("T");
        sb.append(nn.format(1L));
        sb.append("\n");
        return sb.toString();
    }

    public void addEntity(igesEntity theEntity) {
        theEntity.addToFile(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getHeaderBlock());
        sb.append(this.m_DirectoryBlock.toString());
        sb.append(this.m_ParameterBlock.toString());
        sb.append(this.getTerminatorBlock());
        return sb.toString();
    }

    public void dump() {
        System.out.println(this.toString());
    }
}

