/*
 * Decompiled with CFR 0.152.
 */
package MH.AeroTools.Util.Iges;

import MH.AeroTools.Airfoils.DoublePoint;
import MH.AeroTools.Util.Iges.igesEntity;
import MH.AeroTools.Util.Iges.igesFile;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class entitySurface
extends igesEntity {
    private double[][] m_x;
    private double[][] m_y;
    private double[][] m_z;

    public entitySurface(int iPoints, int jCurves) {
        this.m_x = new double[jCurves][iPoints];
        this.m_y = new double[jCurves][iPoints];
        this.m_z = new double[jCurves][iPoints];
    }

    public void setXYCurve(int jCurve, DoublePoint[] pts, double z) {
        if (jCurve > -1 && jCurve < this.m_x.length && pts.length == this.m_x[0].length) {
            int i = 0;
            while (i < this.m_x[0].length) {
                this.m_x[jCurve][i] = pts[i].dX;
                this.m_y[jCurve][i] = pts[i].dY;
                this.m_z[jCurve][i] = z;
                ++i;
            }
        }
    }

    public void setXYCurve(int jCurve, double[] x, double[] y, double[] z) {
        if (jCurve > -1 && jCurve < this.m_x.length && x.length == this.m_x[0].length) {
            int i = 0;
            while (i < this.m_x[0].length) {
                this.m_x[jCurve][i] = x[i];
                this.m_y[jCurve][i] = y[i];
                this.m_z[jCurve][i] = z[i];
                ++i;
            }
        }
    }

    @Override
    protected void addToFile(igesFile igesFile2) {
        DecimalFormat nn = new DecimalFormat("0.0000E00", new DecimalFormatSymbols(Locale.US));
        int startParamIndex = igesFile2.getParamIndex();
        int K1 = this.m_x[0].length - 1;
        int K2 = this.m_x.length - 1;
        int M1 = 3;
        int M2 = 3;
        int N1 = 1 + K1 - M1;
        int N2 = 1 + K2 - M2;
        int A = N1 + 2 * M1;
        int B = N2 + 2 * M2;
        int C = (K1 + 1) * (K2 + 1);
        igesFile2.addToParamBlock("128,");
        igesFile2.addToParamBlock(String.valueOf(K1) + ",");
        igesFile2.addToParamBlock(String.valueOf(K2) + ",");
        igesFile2.addToParamBlock(String.valueOf(M1) + ",");
        igesFile2.addToParamBlock(String.valueOf(M2) + ",");
        igesFile2.addToParamBlock("0,0,");
        igesFile2.addToParamBlock("1,");
        igesFile2.addToParamBlock("0,0,");
        double s = 0.0;
        int i = 0;
        while (i < M1) {
            igesFile2.addToParamBlock(Double.toString(s));
            igesFile2.addToParamBlock(",");
            ++i;
        }
        i = 0;
        while (i <= N1) {
            igesFile2.addToParamBlock(Double.toString(s));
            igesFile2.addToParamBlock(",");
            s += 1.0;
            ++i;
        }
        s -= 1.0;
        i = 0;
        while (i < M1) {
            igesFile2.addToParamBlock(Double.toString(s));
            igesFile2.addToParamBlock(",");
            ++i;
        }
        double t = 0.0;
        int i2 = 0;
        while (i2 < M2) {
            igesFile2.addToParamBlock(Double.toString(t));
            igesFile2.addToParamBlock(",");
            ++i2;
        }
        i2 = 0;
        while (i2 <= N2) {
            igesFile2.addToParamBlock(Double.toString(t));
            igesFile2.addToParamBlock(",");
            t += 1.0;
            ++i2;
        }
        t -= 1.0;
        i2 = 0;
        while (i2 < M2) {
            igesFile2.addToParamBlock(Double.toString(t));
            igesFile2.addToParamBlock(",");
            ++i2;
        }
        i2 = 0;
        while (i2 < C) {
            igesFile2.addToParamBlock("1.0,");
            ++i2;
        }
        int jCurve = 0;
        while (jCurve < this.m_x.length) {
            int iPoint = 0;
            while (iPoint < this.m_x[0].length) {
                igesFile2.addToParamBlock(nn.format(this.m_x[jCurve][iPoint]));
                igesFile2.addToParamBlock(",");
                igesFile2.addToParamBlock(nn.format(this.m_y[jCurve][iPoint]));
                igesFile2.addToParamBlock(",");
                igesFile2.addToParamBlock(nn.format(this.m_z[jCurve][iPoint]));
                igesFile2.addToParamBlock(",");
                ++iPoint;
            }
            ++jCurve;
        }
        igesFile2.addToParamBlock(nn.format(0.0));
        igesFile2.addToParamBlock(",");
        igesFile2.addToParamBlock(nn.format(N1));
        igesFile2.addToParamBlock(",");
        igesFile2.addToParamBlock(nn.format(0.0));
        igesFile2.addToParamBlock(",");
        igesFile2.addToParamBlock(nn.format(N2));
        igesFile2.addToParamBlock(";");
        igesFile2.flushParameterLine();
        int ParamCount = igesFile2.getParamIndex() - startParamIndex;
        igesFile2.addToDirectoryBlock('S', 128, 0, startParamIndex, ParamCount);
    }

    private void debugOut() {
        int jCurve = 0;
        while (jCurve < this.m_x.length) {
            System.err.print("x[" + jCurve + "] =");
            int iPoint = 0;
            while (iPoint < this.m_x[0].length) {
                System.err.print(" ");
                System.err.print(this.m_x[jCurve][iPoint]);
                ++iPoint;
            }
            System.err.println();
            System.err.print("y[" + jCurve + "] =");
            iPoint = 0;
            while (iPoint < this.m_y[0].length) {
                System.err.print(" ");
                System.err.print(this.m_y[jCurve][iPoint]);
                ++iPoint;
            }
            System.err.println();
            System.err.print("z[" + jCurve + "] =");
            iPoint = 0;
            while (iPoint < this.m_z[0].length) {
                System.err.print(" ");
                System.err.print(this.m_z[jCurve][iPoint]);
                ++iPoint;
            }
            System.err.println();
            ++jCurve;
        }
        System.err.println();
    }

    public static void main(String[] args) {
        igesFile f = new igesFile();
        entitySurface s = new entitySurface(5, 6);
        DoublePoint[] pts = new DoublePoint[]{new DoublePoint(0.0, 0.0), new DoublePoint(0.33, 0.1), new DoublePoint(0.5, -0.1), new DoublePoint(0.75, 0.0), new DoublePoint(1.0, 0.0)};
        int iCurve = 0;
        while (iCurve < 6) {
            double zValue = iCurve;
            s.setXYCurve(iCurve, pts, zValue);
            int iPoint = 0;
            while (iPoint < pts.length) {
                pts[iPoint].dY *= 1.5;
                ++iPoint;
            }
            ++iCurve;
        }
        s.addToFile(f);
        f.dump();
    }
}

