/*
 * Decompiled with CFR 0.152.
 */
package MH.AeroTools.Util.Iges;

import MH.AeroTools.Airfoils.DoublePoint;
import MH.AeroTools.Util.CubicSpline;
import MH.AeroTools.Util.Iges.igesEntity;
import MH.AeroTools.Util.Iges.igesFile;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class entitySpline
extends igesEntity {
    CubicSpline[] m_SplineCurve;
    double[] s;

    public entitySpline(double[] x, double[] y, double[] z) {
        this.construct(x, y, z);
    }

    public entitySpline(double[] x, double[] y) {
        double[] z = new double[x.length];
        int i = 0;
        while (i < x.length) {
            z[i] = 0.0;
            ++i;
        }
        this.construct(x, y, z);
    }

    public entitySpline(DoublePoint[] pts) {
        double[] x = new double[pts.length];
        double[] y = new double[pts.length];
        double[] z = new double[pts.length];
        int i = 0;
        while (i < x.length) {
            x[i] = pts[i].dX;
            y[i] = pts[i].dY;
            z[i] = 0.0;
            ++i;
        }
        this.construct(x, y, z);
    }

    private void construct(double[] x, double[] y, double[] z) {
        this.s = new double[x.length];
        this.m_SplineCurve = new CubicSpline[3];
        this.s[0] = 0.0;
        int i = 1;
        while (i < x.length) {
            double dx = x[i] - x[i - 1];
            double dy = y[i] - y[i - 1];
            double dz = z[i] - z[i - 1];
            this.s[i] = this.s[i - 1] + Math.sqrt(dx * dx + dy * dy + dz * dz);
            ++i;
        }
        this.m_SplineCurve[0] = new CubicSpline(this.s, x);
        this.m_SplineCurve[1] = new CubicSpline(this.s, y);
        this.m_SplineCurve[2] = new CubicSpline(this.s, z);
    }

    @Override
    protected void addToFile(igesFile igesFile2) {
        DecimalFormat nn = new DecimalFormat("0.0000E00", new DecimalFormatSymbols(Locale.US));
        int startParamIndex = igesFile2.getParamIndex();
        igesFile2.addToParamBlock("112,");
        igesFile2.addToParamBlock("3,");
        igesFile2.addToParamBlock("2,");
        igesFile2.addToParamBlock("3,");
        igesFile2.addToParamBlock(Integer.toString(this.s.length - 1));
        igesFile2.addToParamBlock(",");
        int i = 0;
        while (i < this.s.length) {
            igesFile2.addToParamBlock(nn.format(this.s[i]));
            igesFile2.addToParamBlock(",");
            ++i;
        }
        i = 0;
        while (i < this.s.length - 1) {
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[0].getD()[i]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[0].getC()[i]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[0].getB()[i]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[0].getA()[i]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[1].getD()[i]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[1].getC()[i]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[1].getB()[i]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[1].getA()[i]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[2].getD()[i]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[2].getC()[i]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[2].getB()[i]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[2].getA()[i]));
            igesFile2.addToParamBlock(",");
            ++i;
        }
        i = 0;
        while (i < 3) {
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[i].EvalPoint(this.s[this.s.length - 1]) / 1.0));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[i].EvalDerivative(this.s[this.s.length - 1], 1) / 1.0));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[i].EvalDerivative(this.s[this.s.length - 1], 2) / 2.0));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_SplineCurve[i].EvalDerivative(this.s[this.s.length - 1], 3) / 6.0));
            if (i < 2) {
                igesFile2.addToParamBlock(",");
            } else {
                igesFile2.addToParamBlock(";");
            }
            ++i;
        }
        igesFile2.flushParameterLine();
        int ParamCount = igesFile2.getParamIndex() - startParamIndex;
        igesFile2.addToDirectoryBlock('C', 112, 0, startParamIndex, ParamCount);
    }

    public static void main(String[] args) {
        double[] x = new double[5];
        double[] y = new double[5];
        double[] z = new double[5];
        x[0] = 0.0;
        x[1] = 1.0;
        x[2] = 2.0;
        x[3] = 1.0;
        x[4] = 0.0;
        y[0] = 0.0;
        y[1] = 0.0;
        y[2] = 1.0;
        y[3] = 1.0;
        y[4] = 1.0;
        z[0] = 0.0;
        z[1] = 1.0;
        z[2] = 1.0;
        z[3] = 1.0;
        z[4] = 0.0;
        igesFile f = new igesFile();
        entitySpline s = new entitySpline(x, y, z);
        s.addToFile(f);
        z[0] = 10.0;
        z[1] = 8.0;
        z[2] = 10.0;
        z[3] = 8.0;
        z[4] = 10.0;
        s = new entitySpline(x, y, z);
        s.addToFile(f);
        s = new entitySpline(x, y);
        s.addToFile(f);
        f.dump();
    }
}

