/*
 * Decompiled with CFR 0.152.
 */
package MH.AeroTools.Util.Iges;

import MH.AeroTools.Util.Iges.igesEntity;
import MH.AeroTools.Util.Iges.igesFile;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class entityCircle
extends igesEntity {
    public static final int PLANE_XY = 1;
    public static final int PLANE_YZ = 2;
    public static final int PLANE_XZ = 3;
    double m_x0;
    double m_y0;
    double m_z0;
    double m_r;
    int m_plane;

    public entityCircle(double x0, double y0, double z0, double r, int plane) {
        this.m_plane = plane;
        this.m_x0 = x0;
        this.m_y0 = y0;
        this.m_z0 = z0;
        this.m_r = r;
    }

    @Override
    protected void addToFile(igesFile igesFile2) {
        DecimalFormat nn = new DecimalFormat("0.0000E00", new DecimalFormatSymbols(Locale.US));
        int startParamIndex = igesFile2.getParamIndex();
        igesFile2.addToParamBlock("126,");
        igesFile2.addToParamBlock("8,");
        igesFile2.addToParamBlock("2,");
        igesFile2.addToParamBlock("1,");
        igesFile2.addToParamBlock("1,");
        igesFile2.addToParamBlock("0,");
        igesFile2.addToParamBlock("1,");
        double t = 0.0;
        igesFile2.addToParamBlock(nn.format(t));
        igesFile2.addToParamBlock(",");
        int i = 0;
        while (i < 5) {
            igesFile2.addToParamBlock(nn.format(t));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(t));
            igesFile2.addToParamBlock(",");
            if (i < 4) {
                t += 1.5707963267948966;
            }
            ++i;
        }
        igesFile2.addToParamBlock(nn.format(t));
        igesFile2.addToParamBlock(",");
        i = 0;
        while (i < 4) {
            igesFile2.addToParamBlock(nn.format(1.0));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(1.0 / Math.sqrt(2.0)));
            igesFile2.addToParamBlock(",");
            ++i;
        }
        igesFile2.addToParamBlock(nn.format(1.0));
        igesFile2.addToParamBlock(",");
        double[][] pxz = new double[][]{{0.0, 1.0, 0.0}, {0.0, 1.0, 1.0}, {0.0, 0.0, 1.0}, {0.0, -1.0, 1.0}, {0.0, -1.0, 0.0}, {0.0, -1.0, -1.0}, {0.0, 0.0, -1.0}, {0.0, 1.0, -1.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}};
        double[][] pyz = new double[][]{{1.0, 0.0, 0.0}, {1.0, 0.0, 1.0}, {0.0, 0.0, 1.0}, {-1.0, 0.0, 1.0}, {-1.0, 0.0, 0.0}, {-1.0, 0.0, -1.0}, {0.0, 0.0, -1.0}, {1.0, 0.0, -1.0}, {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
        double[][] pxy = new double[][]{{1.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {0.0, 1.0, 0.0}, {-1.0, 1.0, 0.0}, {-1.0, 0.0, 0.0}, {-1.0, -1.0, 0.0}, {0.0, -1.0, 0.0}, {1.0, -1.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, 1.0}};
        double[][] trafo = null;
        switch (this.m_plane) {
            case 1: {
                trafo = pxy;
                break;
            }
            case 2: {
                trafo = pxz;
                break;
            }
            case 3: {
                trafo = pyz;
            }
        }
        int i2 = 0;
        while (i2 < 9) {
            igesFile2.addToParamBlock(nn.format(this.m_x0 + this.m_r * trafo[i2][0]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_y0 + this.m_r * trafo[i2][1]));
            igesFile2.addToParamBlock(",");
            igesFile2.addToParamBlock(nn.format(this.m_z0 + this.m_r * trafo[i2][2]));
            igesFile2.addToParamBlock(",");
            ++i2;
        }
        t = 0.0;
        igesFile2.addToParamBlock(nn.format(t));
        igesFile2.addToParamBlock(",");
        t = Math.PI * 2;
        igesFile2.addToParamBlock(nn.format(t));
        igesFile2.addToParamBlock(",");
        igesFile2.addToParamBlock(nn.format(this.m_x0 + trafo[9][0]));
        igesFile2.addToParamBlock(",");
        igesFile2.addToParamBlock(nn.format(this.m_y0 + trafo[9][1]));
        igesFile2.addToParamBlock(",");
        igesFile2.addToParamBlock(nn.format(this.m_z0 + trafo[9][2]));
        igesFile2.addToParamBlock(";");
        igesFile2.flushParameterLine();
        int ParamCount = igesFile2.getParamIndex() - startParamIndex;
        igesFile2.addToDirectoryBlock('C', 126, 2, startParamIndex, ParamCount);
    }

    public static void main(String[] args) {
        igesFile f = new igesFile();
        entityCircle c = new entityCircle(0.0, 0.0, 0.0, 1.0, 1);
        c.addToFile(f);
        c = new entityCircle(0.0, 0.2, 0.0, 1.0, 1);
        c.addToFile(f);
        c = new entityCircle(0.0, -0.2, 0.0, 1.0, 1);
        c.addToFile(f);
        f.dump();
    }
}

