/*
 * Decompiled with CFR 0.152.
 */
package MH;

import MH.InstantScrollbar;
import MH.TunedPipe;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JTextField;

class ActionTextField
extends JTextField
implements ActionListener,
FocusListener {
    private InstantScrollbar isbScrollBar;
    private TunedPipe thePipe;
    private int m_Ident;

    ActionTextField(String sValue, int nIdent, TunedPipe thePipe) {
        super(sValue);
        this.m_Ident = nIdent;
        this.thePipe = thePipe;
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    public void setScrollBar(InstantScrollbar instantScrollbar) {
        this.isbScrollBar = instantScrollbar;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DecimalFormat theFormat = new DecimalFormat();
        theFormat.setGroupingUsed(false);
        theFormat.setMaximumFractionDigits(0);
        theFormat.setMinimumFractionDigits(0);
        try {
            double f = theFormat.parse(this.getText()).doubleValue();
            switch (this.m_Ident) {
                case 0: {
                    this.thePipe.setRPM(f);
                    break;
                }
                case 1: {
                    this.thePipe.setTransferAngle(f);
                    break;
                }
                case 2: {
                    this.thePipe.setExhaustAngle(f);
                    break;
                }
                case 3: {
                    this.thePipe.setExhaustArea(f);
                    break;
                }
                case 4: {
                    f = this.thePipe.setExhaustTemperature(f);
                }
            }
            if (this.isbScrollBar != null) {
                this.isbScrollBar.setValue((int)f);
            }
            this.setText(theFormat.format(f));
        }
        catch (ParseException e) {
            int i = e.getErrorOffset();
            super.select(i, 100);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.actionPerformed(null);
    }
}

